% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VARIMA.R
\name{VARIMA}
\alias{VARIMA}
\alias{report.VARIMA}
\alias{forecast.VARIMA}
\alias{fitted.VARIMA}
\alias{residuals.VARIMA}
\alias{tidy.VARIMA}
\alias{glance.VARIMA}
\alias{generate.VARIMA}
\alias{IRF.VARIMA}
\title{Estimate a VARIMA model}
\usage{
VARIMA(formula, identification = c("kronecker_indices", "none"), ...)

\method{forecast}{VARIMA}(
  object,
  new_data = NULL,
  specials = NULL,
  bootstrap = FALSE,
  times = 5000,
  ...
)

\method{fitted}{VARIMA}(object, ...)

\method{residuals}{VARIMA}(object, ...)

\method{tidy}{VARIMA}(x, ...)

\method{glance}{VARIMA}(x, ...)

\method{report}{VARIMA}(object, ...)

\method{generate}{VARIMA}(x, new_data, specials, ...)

\method{IRF}{VARIMA}(x, new_data, specials, impulse = NULL, orthogonal = FALSE, ...)
}
\arguments{
\item{formula}{Model specification (see "Specials" section).}

\item{identification}{The identification technique used to estimate the model.}

\item{...}{Further arguments for arima}

\item{object}{A model for which forecasts are required.}

\item{new_data}{A tsibble containing the time points and exogenous regressors to produce forecasts for.}

\item{specials}{(passed by \code{\link[fabletools:forecast]{fabletools::forecast.mdl_df()}}).}

\item{bootstrap}{If \code{TRUE}, then forecast distributions are computed using simulation with resampled errors.}

\item{times}{The number of sample paths to use in estimating the forecast distribution when \code{bootstrap = TRUE}.}

\item{x}{A fitted model.}

\item{impulse}{A character string specifying the name of the variable that is shocked (the impulse variable).}

\item{orthogonal}{If TRUE, orthogonalised impulse responses will be computed.}
}
\value{
A model specification.

A one row tibble summarising the model's fit.
}
\description{
Estimates a VARIMA model of a given order.
}
\details{
Exogenous regressors and \code{\link{common_xregs}} can be specified in the model
formula.
}
\section{Specials}{


\subsection{pdq}{
The \code{pdq} special is used to specify non-seasonal components of the model.
\preformatted{
pdq(p = 0:5, d = 0:2, q = 0:5)
}

\tabular{ll}{
\code{p}      \tab The order of the non-seasonal auto-regressive (AR) terms. If multiple values are provided, the one which minimises \code{ic} will be chosen. \cr
\code{d}      \tab The order of integration for non-seasonal differencing. If multiple values are provided, one of the values will be selected via repeated KPSS tests. \cr
\code{q}      \tab The order of the non-seasonal moving average (MA) terms. If multiple values are provided, the one which minimises \code{ic} will be chosen. \cr
}
}
\subsection{xreg}{
Exogenous regressors can be included in an VARIMA model without explicitly using the \code{xreg()} special. Common exogenous regressor specials as specified in \code{\link{common_xregs}} can also be used. These regressors are handled using \code{\link[stats:model.frame]{stats::model.frame()}}, and so interactions and other functionality behaves similarly to \code{\link[stats:lm]{stats::lm()}}.

The inclusion of a constant in the model follows the similar rules to \code{\link[stats:lm]{stats::lm()}}, where including \code{1} will add a constant and \code{0} or \code{-1} will remove the constant. If left out, the inclusion of a constant will be determined by minimising \code{ic}.

\preformatted{
xreg(...)
}

\tabular{ll}{
\code{...}      \tab Bare expressions for the exogenous regressors (such as \code{log(x)})
}
}
}

\examples{
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
library(tsibbledata)

aus_production \%>\% 
  autoplot(vars(Beer, Cement))

fit <- aus_production \%>\%
  model(VARIMA(vars(Beer, Cement) ~ pdq(4,1,1), identification = "none"))

fit
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

fit \%>\%
  forecast(h = 50) \%>\%
  autoplot(tail(aus_production, 100))
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}

fitted(fit)
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
residuals(fit)
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
tidy(fit)
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
glance(fit)
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
report(fit)
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
generate(fit, h = 10)
\dontshow{\}) # examplesIf}
\dontshow{if (requireNamespace("tsibbledata", quietly = TRUE)) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
IRF(fit, h = 10, impulse = "Beer")
\dontshow{\}) # examplesIf}
}
\seealso{
\code{\link[MTS:VARMA]{MTS::VARMA()}}, \code{\link[MTS:Kronfit]{MTS::Kronfit()}}.
}
