% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/croston.R
\name{CROSTON}
\alias{CROSTON}
\title{Croston's method}
\usage{
CROSTON(formula, opt_crit = c("mse", "mae"), ...)
}
\arguments{
\item{formula}{Model specification (see "Specials" section).}

\item{opt_crit}{The optimisation criterion used to optimise the parameters.}

\item{...}{Not used.}
}
\value{
A model specification.
}
\description{
Based on Croston's (1972) method for intermittent demand forecasting, also described in Shenstone and Hyndman (2005). Croston's method involves using simple exponential smoothing (SES) on the non-zero elements of the time series and a separate application of SES to the times between non-zero elements of the time series.
}
\details{
Note that forecast distributions are not computed as Croston's method has no underlying stochastic model. In a later update, we plan to support distributions via the equivalent stochastic models that underly Croston's method (Shenstone and Hyndman, 2005)
}
\section{Specials}{


\subsection{demand}{
The \code{demand} special specifies parameters for the demand SES application.
\preformatted{
demand(initial = NULL, param = NULL)
}

\tabular{ll}{
\code{initial}  \tab The initial value for the demand application of SES. \cr
\code{param}    \tab The smoothing parameter for the demand application of SES.
}
}

\subsection{interval}{
The \code{interval} special specifies parameters for the interval SES application.
\preformatted{
interval(initial = NULL, param = NULL)
}

\tabular{ll}{
\code{initial}  \tab The initial value for the interval application of SES. \cr
\code{param}    \tab The smoothing parameter for the interval application of SES.
}
}
}

\examples{
library(tsibble)
sim_poisson <- tsibble(
  time = yearmonth("2012 Dec") + seq_len(24),
  count = rpois(24, lambda = 0.3),
  index = time
)

sim_poisson \%>\%
  autoplot(count)

sim_poisson \%>\%
  model(CROSTON(count)) \%>\%
  forecast(h = "2 years") \%>\%
  autoplot(sim_poisson)
}
\references{
Croston, J. (1972) "Forecasting and stock control for
intermittent demands", \emph{Operational Research Quarterly}, \bold{23}(3),
289-303.

Shenstone, L., and Hyndman, R.J. (2005) "Stochastic models underlying
Croston's method for intermittent demand forecasting". \emph{Journal of
Forecasting}, \bold{24}, 389-402.

Kourentzes, N. (2014) "On intermittent demand model optimisation and
selection". \emph{International Journal of Production Economics}, \bold{156},
180-190. \url{http://dx.doi.org/10.1016/j.ijpe.2014.06.007}.
}
