% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/load_pitstops.R
\name{load_pitstops}
\alias{load_pitstops}
\title{Load Pitstop Data}
\usage{
load_pitstops(
  season = get_current_season(),
  round = "last",
  race = lifecycle::deprecated()
)
}
\arguments{
\item{season}{number from 2011 to current season (defaults to current season).}

\item{round}{number from 1 to 23 (depending on season selected) and defaults
to most recent.Also accepts \code{'last'}.}

\item{race}{\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#deprecated}{\figure{lifecycle-deprecated.svg}{options: alt='[Deprecated]'}}}{\strong{[Deprecated]}} \code{race} is no longer supported, please use \code{round}.}
}
\value{
A tibble with columns driver_id, lap, stop (number), time (of day),
and stop duration
}
\description{
Loads pit stop info (number, lap, time elapsed) for a given race
in a season. Pit stop data is available from 2012 onward.
Call \code{.load_pitstops()} for an uncached version.
}
