% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/indexclim.R
\name{indexclim}
\alias{indexclim}
\title{Function which computes the index for the climatological CRPS/MAE. You must provide the observations. If you computes climatological CRPS/MAE previously, you can add the corresponding vector}
\usage{
indexclim(y, thresh = NULL, score_clim = NULL, xi = NULL,
  score = "crps")
}
\arguments{
\item{y}{The observations}

\item{thresh}{Vector of thresholds where you want to compute the index}

\item{score_clim}{If not NULL, must be the time serie of the CRPS/MAE of the climatology. It is recommended to compute CRPS/MAE out of this function}

\item{xi}{Shape parameter of the GP}

\item{score}{A character string indicating if you want to work with CRPS ("crps") or MAE ("mae"), by default "crps"}
}
\value{
An indexclim object containing xi, y, the score time serie, the score considered, the index values, and the corresponding quantiles of the observations
}
\description{
Function which computes the index for the climatological CRPS/MAE. You must provide the observations. If you computes climatological CRPS/MAE previously, you can add the corresponding vector
}
