% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/gamma-poisson-distribution.R
\name{GammaPoiss}
\alias{GammaPoiss}
\alias{dgpois}
\alias{pgpois}
\alias{rgpois}
\title{Gamma-Poisson distribution}
\usage{
dgpois(x, shape, rate, scale = 1/rate, log = FALSE)

pgpois(q, shape, rate, scale = 1/rate, lower.tail = TRUE, log.p = FALSE)

rgpois(n, shape, rate, scale = 1/rate)
}
\arguments{
\item{x, q}{vector of quantiles.}

\item{shape, scale}{shape and scale parameters. Must be positive,
scale strictly.}

\item{rate}{an alternative way to specify the scale.}

\item{log, log.p}{logical; if TRUE, probabilities p are given as log(p).}

\item{lower.tail}{logical; if TRUE (default), probabilities are \eqn{P[X \le x]}
otherwise, \eqn{P[X > x]}.}

\item{n}{number of observations. If \code{length(n) > 1},
the length is taken to be the number required.}
}
\description{
Probability mass function and random generation
for the gamma-Poisson distribution.
}
\details{
Gamma-Poisson distribution arises as a continuous mixture of
Poisson distributions, where where the mixing distribution
of the Poisson rate \eqn{\lambda} is a gamma distribution.
When \eqn{X \sim \mathrm{Poisson}(\lambda)}{X ~ Poisson(\lambda)}
and \eqn{\lambda \sim \mathrm{Gamma}(\alpha, \beta)}{\lambda ~ Gamma(\alpha, \beta)}, then \eqn{X \sim \mathrm{GammaPoisson}(\alpha, \beta)}{X ~ Gamma-Poisson(\alpha, \beta)}.

Probability density function (parametrized by scale)
\deqn{
f(x) = \frac{\Gamma(\alpha+x)}{x! \Gamma(\alpha)} p^k (1-p)^\alpha
}{
f(x) = \Gamma(\alpha+x) / (x!*\Gamma(\alpha)) * p^x * (1-p)^\alpha
}

where \eqn{p = \frac{\beta}{1+\beta}}{p = \beta/(1+\beta)}.

\emph{Warning:} cumulative distribution function is defined as
\eqn{\sum_{k=0}^x f(k)}{f(0)+...+f(x)} so it may be slow for
large detasets.
}
\examples{

x <- rgpois(1e5, 7, 0.002)
xx <- seq(0, 12000, by = 1)
hist(x, 100, freq = FALSE)
lines(xx, dgpois(xx, 7, 0.002), col = "red")
hist(pgpois(x, 7, 0.002))
plot(ecdf(x))
lines(xx, pgpois(xx, 7, 0.002), col = "red", lwd = 2)

}
\seealso{
\code{\link[stats]{Gamma}}, \code{\link[stats]{Poisson}}
}
\keyword{distribution}

