% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pct_routine.R
\name{pct_routine}
\alias{pct_routine}
\alias{pct_routine_}
\alias{tally_pct}
\alias{tally_pct_}
\title{Calculate percentage by group.}
\usage{
pct_routine(
  data,
  ...,
  wt = NULL,
  ret_name = "pct",
  rebase = FALSE,
  ungroup = FALSE
)

pct_routine_(
  data,
  vars,
  wt = NULL,
  ret_name = "pct",
  rebase = FALSE,
  ungroup = FALSE
)

tally_pct(data, wt = NULL, ret_name = "pct", rebase = FALSE)

tally_pct_(data, wt = NULL, ret_name = "pct", rebase = FALSE)
}
\arguments{
\item{data}{A \code{\link[base]{data.frame}} or \code{\link[dplyr]{tbl}}.}

\item{...}{Variables to group by, see \code{\link[dplyr]{group_by}}.}

\item{wt}{Column name of weights.}

\item{ret_name}{Character of the variable name returned.}

\item{rebase}{Whether to remove the missing values in the percentage, e.g.
rebase the percentage so that NAs in the last group are excluded.}

\item{ungroup}{Whether to ungroup the returned table.}

\item{vars}{A character vector of variable names to group by.}
}
\description{
\code{pct_routine} works like \code{\link[dplyr]{count}} except that it
returns group percentages instead of counts. \code{tally_pct} is a underlying
utility function that corresponds to \code{tally}. As the name implies, it
also returns percentage.
}
\section{Functions}{
\itemize{
\item \code{pct_routine_}: SE version of \code{pct_routine}.

\item \code{tally_pct}: NSE version of \code{tally_pct_}.

\item \code{tally_pct_}: Underlying SE function of \code{pct_routine_} without
options for groups.
}}

\examples{
data(esoph)
esoph
pct_routine(esoph, agegp, alcgp)
pct_routine(esoph, agegp, alcgp, wt = ncases)
# Crate new grouping variables
pct_routine(esoph, agegp, low_alcgp = alcgp \%in\% c("0-39g/day", "40-79"))


# This examples shows how rebase works
if (require(dplyr)) {
  iris \%>\%
    mutate(random_missing = ifelse(rnorm(n()) > 0, NA, round(Sepal.Length))) \%>\%
    group_by(Species, random_missing) \%>\%
    tally_pct(wt = Sepal.Width, rebase = TRUE)
}
}
