% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expReorder.R
\name{expReorder}
\alias{expReorder}
\title{Change the order of elements that an experiment contains}
\usage{
expReorder(e, elements, placeRestAtEnd = TRUE)
}
\arguments{
\item{e}{Input experiment}

\item{elements}{A list of arrays of strings containing the ordered names.
The name for the parameter, method or problem will be given by the name of the
corresponding object in the list.
The names which have not been specified will be placed at the begining or at
the end (depending on the parameter placeRestAtEnd).
If a name is not present in the set of parameter values, it will be ignored.}

\item{placeRestAtEnd}{Logical value which indicates if the non specified
value names have to be placed after the specified ones (TRUE) or before (FALSE).}
}
\value{
A modified exreport experiment object with some changes on the name of
the elements.
}
\description{
This function change the order of problems, methods or parameter values that
an existing experiment object contains. The order affects the look of the
data representation (as tables and plots).
}
\examples{
# We load the wekaExperiment problem as an experiment and then change the order
# of the values for the parameter featureSelection and for one valoue for the method.

experiment <- expCreate(wekaExperiment, name="test", parameter="fold")
expReorder(experiment, list(featureSelection = c("yes","no"),
                           method=c("OneR")))
}

