% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expGetDuplicated.R
\name{expGetDuplicated}
\alias{expGetDuplicated}
\title{Create a new experiment with only the duplicated rows}
\usage{
expGetDuplicated(e, tol = 1e-09)
}
\arguments{
\item{e}{The experiment to check for duplicated rows}

\item{tol}{The tolerance for numeric values to check if two outputs are
numerically equal or not.}
}
\value{
A new experiment containing the duplicated rows
}
\description{
This function computes the duplicated rows attending to the method, problem
and input parameters (but not the outputs). The resulting experiment will
contain these duplicated rows.
}
\details{
If duplicated rows show different outputs the function will launch a
a warning message indicating how many of them differ in the outputs from the
original row, the extent to what two rows are divergent in their output can be
parametrized.

This function is useful to determine the consistency of the experiment, as a
measure to sanitice the original data source if needed,
}
\examples{
# We duplicate some of the rows of a given experiment:
e <- expCreate(wekaExperiment, parameters="fold", name="Test Experiment")
redundant <- expCreate(wekaExperiment[wekaExperiment$method=="NaiveBayes",],
                       parameters="fold", name="Test Experiment")
e2 <- expConcat(e,redundant)

# Now we check for duplicates:
expGetDuplicated(e2)
}

