% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/fun_expCreate.R
\name{expCreate}
\alias{expCreate}
\title{Load data and create an exreport experiment}
\usage{
expCreate(data, methods = "method", problems = "problem",
  parameters = c(), respectOrder = FALSE, name, tol = 1e-09)
}
\arguments{
\item{data}{A data.frame object satisfying the experiment format}

\item{methods}{The name of the variable which contains the methods, by default
is searches for a column named "method".}

\item{problems}{The name of the variable which contains the problems, by
default is searches for a column named "problem".}

\item{parameters}{A list of the columns names to be identified as parameters.
By default the remaining categorical columns
are identified as parameters, so this list is useful only to identify numeric
columns.}

\item{respectOrder}{A logical parameter which indicates if the order of the
elements of the method and problem columns must be respected by appearance or
ordered alphabeticaly. It affects to the look of data representations.}

\item{name}{A string which will identify the experiment in the report.}

\item{tol}{Tolerance factor to identify repeated experiments for duplicated
rows.}
}
\value{
A new exreport experiment object.
}
\description{
This function loads a data.frame, checks its properties and formats an
exreport experiment object. The columns of an experiments must contain at
least two categorical columns to be identified as the method and problem
variables and a thrid numerical column to be identified as an output variable.
Additional columns can be added as parameters or additional outputs.
}
\examples{
# Creates experiment specifying column names and the numerical variables that
# are parameters

expCreate(wekaExperiment,
methods="method",
problems="problem",
parameters="fold",
name="Test Experiment")
}
\seealso{
expCreateFromTable
}

