% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{balance_target}
\alias{balance_target}
\title{Balance target variable}
\usage{
balance_target(data, target, min_prop = 0.1)
}
\arguments{
\item{data}{A dataset}

\item{target}{Target variable (0/1, TRUE/FALSE, yes/no)}

\item{min_prop}{Minimum proportion of one of the target categories}
}
\value{
Data
}
\description{
Balances the target variable in your dataset.
Target must be 0/1, FALSE/TRUE ore no/yes
}
\examples{
iris$is_versicolor <- ifelse(iris$Species == "versicolor", 1, 0)
balanced <- balance_target(iris, target = is_versicolor, min_prop = 0.5)
describe(balanced, is_versicolor)
}
