% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/kgaps_methods.R
\name{print.kgaps}
\alias{print.kgaps}
\title{Print method for a \code{"kgaps"} object}
\usage{
\method{print}{kgaps}(x, digits = max(3L, getOption("digits") - 3L), ...)
}
\arguments{
\item{x}{an object of class \code{c("kgaps", "exdex")}, a result of
a call to \code{\link{kgaps}}.}

\item{digits}{The argument \code{digits} to \code{\link{print.default}}.}

\item{...}{Additional arguments.  None are used in this function.}
}
\value{
The argument \code{x}, invisibly, as for all
  \code{\link[base]{print}} methods.
}
\description{
\code{print} method for class \code{c("kgaps", "exdex")}.
}
\details{
Prints the original call to \code{\link{kgaps}}
  and the estimate of the extremal index \eqn{\theta}.
}
\seealso{
\code{\link{kgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{K}-gaps model.

\code{\link{confint.kgaps}}: \code{confint} method for
  class \code{"kgaps"}.
}
