% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exdex.R
\docType{package}
\name{exdex}
\alias{exdex}
\alias{exdex-package}
\title{exdex: Estimation of the Extremal Index}
\description{
The extremal index \eqn{\theta} is a measure of the degree of local
dependence in the extremes of a stationary process.  The \emph{exdex}
package  performs frequentist inference about \eqn{\theta} using the
methodologies proposed in Northrop (2015), Berghaus and Bucher (2018),
Suveges (2007) and Suveges and Davison (2010).
}
\details{
Functions to implement three estimators of the extremal index
  are provided, namely
\itemize{
  \item{\code{\link{spm}}: semiparametric maxima estimator, using block
    maxima: (Northrop, 2015; Berghaus and Bucher, 2018)}
  \item{\code{\link{kgaps}}: \eqn{K}-gaps estimator, using threshold
    interexceedance times (Suveges and Davison, 2010)}
  \item{\code{\link{iwls}}: iterated weighted least squares estimator,
    using threshold interexceedance times: (Suveges, 2007)}
}

  See \code{vignette("exdex-vignette", package = "exdex")} for an
  overview of the package.
}
\references{
Berghaus, B., Bucher, A. (2018) Weak convergence of a pseudo
maximum likelihood estimator for the extremal index. \emph{Ann. Statist.}
\strong{46}(5), 2307-2335. \url{https://doi.org/10.1214/17-AOS1621}

Northrop, P. J. (2015) An efficient semiparametric maxima
estimator of the extremal index. \emph{Extremes} \strong{18}(4), 585-603.
\url{https://doi.org/10.1007/s10687-015-0221-5}

Suveges, M. (2007) Likelihood estimation of the extremal
  index. \emph{Extremes}, \strong{10}, 41-55.
  \url{https://doi.org/10.1007/s10687-007-0034-2}

Suveges, M. and Davison, A. C. (2010) Model
  misspecification in peaks over threshold analysis, \emph{The Annals of
  Applied Statistics}, \strong{4}(1), 203-221.
  \url{https://doi.org/10.1214/09-AOAS292}
}
\seealso{
\code{\link{spm}} for estimation of the extremal index
  \eqn{\theta} using a semiparametric maxima method.

\code{\link{kgaps}} for maximum likelihood estimation of the
  extremal index \eqn{\theta} using the \eqn{K}-gaps model.

\code{\link{iwls}}: iterated weighted least squares estimator.

\code{\link{newlyn}} and \code{\link{sp500}} for example datasets.
}
