% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simconf.R
\name{simconf}
\alias{simconf}
\title{Simultaneous confidence regions for Gaussian models}
\usage{
simconf(alpha, mu, Q, n.iter = 10000, Q.chol, vars, ind = NULL,
  verbose = 0, max.threads = 0, seed = NULL)
}
\arguments{
\item{alpha}{Error probability for the region.}

\item{mu}{Expectation vector for the Gaussian distribution.}

\item{Q}{Precision matrix for the Gaussian distribution.}

\item{n.iter}{Number or iterations in the MC sampler that is used for
approximating probabilities. The default value is 10000.}

\item{Q.chol}{The Cholesky factor of the precision matrix (optional).}

\item{vars}{Precomputed marginal variances (optional).}

\item{ind}{Indices of the nodes that should be analyzed (optional).}

\item{verbose}{Set to TRUE for verbose mode (optional).}

\item{max.threads}{Decides the number of threads the program can use.
Set to 0 for using the maximum number of threads allowed by the system (default).}

\item{seed}{Random seed (optional).}
}
\value{
An object of class "excurobj" with elements
\item{a }{The lower bound.}
\item{b }{The upper bound.}
\item{a.marginal }{The lower bound for pointwise confidence bands.}
\item{b.marginal }{The upper bound for pointwise confidence bands.}
}
\description{
\code{simconf} is used for calculating simultaneous confidence regions for
Gaussian models \eqn{x}. The function returns upper and lower bounds \eqn{a}
and \eqn{b} such that \eqn{P(a<x<b) = 1-alpha}.
}
\details{
The pointwise confidence bands are based on the marginal quantiles,
meaning that \code{a.marignal = mu +} \eqn{q_{alpha}} and \code{b.marginal = mu +} 
\eqn{q_{1-alpha}}, where \code{mu} is the mean and \eqn{q_{alpha}} is a 
vector with the alpha-quantiles of \code{x-mu}.

The simultaneous confidence bands are defined as
\code{a = mu +} \eqn{c*q_{alpha}} and \code{b = mu +} \eqn{c*q_{1-alpha}}, where 
\eqn{c} is a constant computed such that \eqn{P(a < x < b) = 1-alpha}.
}
\examples{
## Create mean and a tridiagonal precision matrix
n = 11
mu.x = seq(-5, 5, length=n)
Q.x = Matrix(toeplitz(c(1, -0.1, rep(0, n-2))))
## calculate the confidence region
conf = simconf(0.05, mu.x, Q.x, max.threads=2)
## Plot the region
plot(mu.x, type="l", ylim=c(-10, 10),
     main='Mean (black) and confidence region (red)')
lines(conf$a, col=2)
lines(conf$b, col=2)
}
\references{
Bolin et al. (2015) \emph{Statistical prediction of global sea level
from global temperature}, Statistica Sinica, vol 25, pp 351-367.

Bolin, D. and Lindgren, F. (2018), \emph{Calculating Probabilistic Excursion Sets and Related Quantities Using excursions}, Journal of Statistical Software, vol 86, no 1, pp 1-20.
}
\seealso{
\code{\link{simconf.inla}}, \code{\link{simconf.mc}}, \code{\link{simconf.mixture}}
}
\author{
David Bolin \email{davidbolin@gmail.com} and Finn Lindgren \email{finn.lindgren@gmail.com}
}
