\name{continuous}
\alias{continuous}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
  Calculate continuous domain excursion and credible contour sets
}
\description{
  Calculates continuous domain excursion and credible contour sets
}
\usage{
continuous(ex, geometry, alpha,
           method = c("log", "logit", "linear", "step"),
           output = c("sp", "inla"))
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{ex}{
    An \code{excurobj} object generated by a call to
    \code{\link{excursions}} or \code{\link{contourmap}}.
}
\item{geometry}{
  Specification of the lattice or triangulation geometry of the input.
One of
\code{list(x, y)}, \code{list(loc, dims)}, \code{inla.mesh.lattice}, or
\code{inla.mesh}, where \code{x} and \code{y} are vectors, \code{loc} is
a two-column matrix of coordinates, and \code{dims} is the lattice size
vector.  The first three versions are all treated
topologically as lattices, and the lattice boxes are assumed convex.
}
\item{alpha}{
  The target error probability.  A warning is given if it is detected
  that the information \code{ex} isn't sufficient for the given
  \code{alpha}.  Defaults to the value used when calculating \code{ex}
}
\item{method}{
  The spatial probability interpolation transformation method to use.
  One of \code{log}, \code{logit}, \code{linear}, or
  \code{step}.  For \code{log} and \code{logit}, the probabilities are
  interpolated linearly in the transformed scale. For \code{step}, a
  conservative step function is used.
}
\item{output}{
  Specifies what type of object should be generated. \code{sp} gives a
  \code{SpatialPolygons} object, and \code{inla} gives a
  \code{inla.mesh.segment} object.
}
}

\value{
  A list:
  \item{M}{\code{SpatialPolygons} or \code{inla.mesh.segment} object.

  The subsets are tagged, so that credible regions are tagged \code{"-1"}, and
  regions between levels are tagged \code{as.character(0:nlevels)}.
}
  \item{F}{Interpolated F function}
  \item{G}{Contour and inter-level set indices for the interpolation}
  \item{F.geometry}{Mesh geometry for the interpolation}
  \item{P0}{P0 measure based on interpolated F function (only for
  \code{contourmap} input)}
}
%%\references{
%% ~put references to the literature/web site here ~
%%}
\author{
Finn Lindgren
}
%%\note{
%%  ~~further notes~~
%%}

%% ~Make other sections like Warning with \section{Warning }{....} ~

%%\seealso{
%% ~~objects to See Also as \code{\link{help}}, ~~~
%%}
\examples{
\donttest{
if (require(INLA)) {
  #Generate mesh and SPDE model
  n.lattice = 10 #Increase for more interesting, but slower, examples
  x=seq(from=0,to=10,length.out=n.lattice)
  lattice=inla.mesh.lattice(x=x,y=x)
  mesh=inla.mesh.create(lattice=lattice, extend=FALSE, refine=FALSE)
  spde <- inla.spde2.matern(mesh, alpha=2)

  #Generate an artificial sample
  sigma2.e = 0.01
  n.obs=100
  obs.loc = cbind(runif(n.obs)*diff(range(x))+min(x),
                  runif(n.obs)*diff(range(x))+min(x))
  Q = inla.spde2.precision(spde, theta=c(log(sqrt(0.5)), log(sqrt(1))))
  x = inla.qsample(Q=Q)
  A = inla.spde.make.A(mesh=mesh,loc=obs.loc)
  Y = as.vector(A \%*\% x + rnorm(n.obs)*sqrt(sigma2.e))

  ## Calculate posterior
  Q.post = (Q + (t(A)\%*\%A)/sigma2.e)
  mu.post = as.vector(solve(Q.post,(t(A)\%*\%Y)/sigma2.e))
  vars.post = excursions.variances(chol(Q.post))

  ## Calculate contour map with two levels
  map = contourmap(n.levels = 2, mu = mu.post, Q = Q.post,
                   alpha=0.1, F.limit = 0.1)

  ## Calculate the continuous representation
  sets <- continuous(map, mesh, alpha=0.1)

  ## Plot the results
  reo = mesh$idx$lattice
  cols = contourmap.colors(map, col=heat.colors(100, 1),
                           credible.col = grey(0.5, 1))
  names(cols) = as.character(-1:2)

  par(mfrow = c(2,2))
  image(matrix(mu.post[reo],n.lattice,n.lattice),main="mean",axes=F)
  image(matrix(sqrt(vars.post[reo]),n.lattice,n.lattice),main="sd", axes = F)
  image(matrix(map$M[reo],n.lattice,n.lattice),col=cols,axes=F)
  idx.M = setdiff(names(sets$M), "-1")
  plot(sets$M[idx.M], col=cols[idx.M])
}
}
}
