% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm1_data.R
\name{lm1_data}
\alias{lm1_data}
\alias{slr_data}
\title{Simple Linear Regression and Data Generation}
\usage{
lm1_data(
  r,
  n = 100,
  nmax = 6,
  maxt = 30,
  xsos = NULL,
  ysos = NULL,
  center = numeric(0),
  scale = numeric(0),
  ...
)

slr_data(
  r,
  n = 100,
  nmax = 6,
  maxt = 30,
  xsos = NULL,
  ysos = NULL,
  center = numeric(0),
  scale = numeric(0),
  ...
)
}
\arguments{
\item{r}{numeric: desired correlation}

\item{n}{integer: number to decompose as sum of squares, see \code{\link[=pearson_data]{pearson_data()}}.}

\item{nmax}{integer: maximal number of squares in the sum, see \code{\link[=pearson_data]{pearson_data()}}.}

\item{maxt}{numeric: maximal number of seconds the routine should run, see \code{\link[=pearson_data]{pearson_data()}}.}

\item{xsos}{sos matrix: precomputed matrix, see \code{\link[=pearson_data]{pearson_data()}}.}

\item{ysos}{sos matrix: precomputed matrix, see \code{\link[=pearson_data]{pearson_data()}}.}

\item{center}{numeric(2): center of \code{x} and \code{y} data}

\item{scale}{numeric(2): standard deviation for \code{x} and \code{y} data}

\item{...}{further named parameters given to \code{\link[stats:lm]{stats::lm()}}}
}
\value{
Returns an extended \code{lm} object and the additional list elements:
\itemize{
\item \code{inter} contains intermediate results (the last column contains the row sums), and
\item \code{xy} the generated \eqn{x}- and \eqn{y}-values.
}
}
\description{
Creates data suitable for a simple linear regression. In the first step, data is computed using \code{\link[=pearson_data]{pearson_data()}},
satisfying the conditions \eqn{\sum_{i=1}^{nmax} x_i^2 = n} and  \eqn{\sum_{i=1}^{nmax} x_i = 0} (similar conditions apply to \eqn{y}.
The data are then rescaled with \eqn{x' = center[1]+scale[1]*x} and
\eqn{y' = center[2]+scale[2]*y}.
Finally, a simple linear regression is performed on the transformed data.
}
\examples{
data(sos)
n   <- sample(5:10, 1)
lm1 <- lm1_data(0.6, nmax=n, xsos=sos100)
str(lm1)
}
