% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ddiscrete.R
\name{ddiscrete}
\alias{ddiscrete}
\title{Discrete Probability Function}
\usage{
ddiscrete(x, unit = NULL, zero = FALSE)
}
\arguments{
\item{x}{numeric: number of elements of vector of initial probabilities}

\item{unit}{integer: reciprocal of the smallest non-zero probability (default: \code{NULL})}

\item{zero}{logical: zeros are allowed in the final probabilities (default: \code{FALSE})}
}
\value{
A discrete probability function.
}
\description{
Creates a discrete probability function based on \code{x} with a resolution \code{unit}.
If \code{unit} is not given then \code{unit} will be 10, 100, 1000, ... depending
on the length of the discrete probability function.
}
\examples{
ddiscrete(runif(6))
ddiscrete(6)
ddiscrete(6, 20)
ddiscrete(c(1,0,0,0), zero=TRUE)
}
