% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/14_GRM.R
\name{GRM}
\alias{GRM}
\title{Graded Response Model (GRM)}
\usage{
GRM(U, na = NULL, Z = NULL, w = NULL, verbose = TRUE)
}
\arguments{
\item{U}{Either an object of class "exametrika" or raw data. When raw data is given,
it is converted to the exametrika class using the \code{\link{dataFormat}} function.}

\item{na}{Specifies numbers or characters to be treated as missing values.}

\item{Z}{Missing indicator matrix of type matrix or data.frame. 1 indicates observed values, 0 indicates missing values.}

\item{w}{Item weight vector}

\item{verbose}{Logical; if TRUE, shows progress of iterations (default: TRUE)}
}
\value{
A list of class "exametrika" and "GRM" containing the following elements:
\describe{
\item{testlength}{Length of the test (number of items)}
\item{nobs}{Sample size (number of rows in the dataset)}
\item{log_lik}{Log-likelihood value at convergence}
\item{iterations}{Number of iterations and function evaluations from optimization}
\item{params}{Matrix containing the estimated item parameters}
\item{EAP}{Ability parameters of examinees estimated by EAP method}
\item{MAP}{Ability parameters of examinees estimated by MAP method}
\item{PSD}{Posterior standard deviation of the ability parameters}
\item{ItemFitIndices}{Fit indices for each item. See also \code{\link{ItemFit}}}
\item{TestFitIndices}{Overall fit indices for the test. See also \code{\link{TestFit}}}
}
}
\description{
Implements Samejima's (1969) Graded Response Model (GRM), which is an Item Response Theory
model for ordered categorical response data. The model estimates discrimination parameters
and category threshold parameters for each item. It is widely used in psychological measurement,
educational assessment, and other fields that deal with multi-step rating scales.
}
\examples{
\donttest{
# Apply GRM to example data
result <- GRM(J5S1000)
print(result)
plot(result, type = "IRF")
plot(result, type = "IIF")
plot(result, type = "TIF")
}
}
\references{
Samejima, F. (1969). Estimation of latent ability using a response pattern of graded scores.
Psychometrika Monograph Supplement, 34(4, Pt. 2), 1-100.
}
