% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/exploration.R
\name{plot_density_3D}
\alias{plot_density_3D}
\title{Density plot in 3D, considering Start time and Connection duration as variables}
\usage{
plot_density_3D(
  sessions,
  start = getOption("evprof.start.hour"),
  eye = list(x = -1.5, y = -1.5, z = 1.5),
  log = FALSE
)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof
\href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{standard format}.}

\item{start}{integer, start hour in the x axis of the plot.}

\item{eye}{list containing x, y and z points of view. Example: \code{list(x = -1.5, y = -1.5, z = 1.5)}}

\item{log}{logical, whether to transform \code{ConnectionStartDateTime} and
\code{ConnectionHours} variables to natural logarithmic scale (base = \code{exp(1)}).}
}
\value{
plotly plot (html)
}
\description{
Density plot in 3D, considering Start time and Connection duration as variables
}
\examples{
library(dplyr)
california_ev_sessions \%>\%
  sample_frac(0.05) \%>\%
  plot_density_3D(start = 3)

}
