% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{plot_outliers}
\alias{plot_outliers}
\title{Plot outlying sessions}
\usage{
plot_outliers(sessions, log = FALSE, ...)
}
\arguments{
\item{sessions}{tibble, sessions data set in evprof
\href{https://mcanigueral.github.io/evprof/articles/sessions-format.html}{standard format}.}

\item{log}{logical, whether to transform \code{ConnectionStartDateTime} and
\code{ConnectionHours} variables to natural logarithmic scale (base = \code{exp(1)}).}

\item{...}{arguments to pass to function ggplot2::plot_point}
}
\value{
ggplot2 plot
}
\description{
Plot outlying sessions
}
\examples{
\donttest{
sessions_outliers <- detect_outliers(california_ev_sessions, noise_th = 5)
plot_outliers(sessions_outliers)
plot_outliers(sessions_outliers, log = TRUE)
}

}
