% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/normalize.credpart.R
\name{normalize.credpart}
\alias{normalize.credpart}
\title{Normalization of a credal partition}
\usage{
normalize.credpart(clus, method = "d")
}
\arguments{
\item{clus}{An object of class \code{"credpart"}, encoding a credal partition.}

\item{method}{Normalization method ("d" for Dempster or "y" for Yager).}
}
\value{
The normalized credal partition (a \code{"credpart"} object).
}
\description{
\code{normalize.credpart} normalizes a credal partition (a \code{"credpart"} object).
}
\details{
The function implements two normalization methods: Dempster's normalization (the mass of each focal set
is divided by one minus the mass on the empty set), and yager's normalization (the mass of the empty set
is transfered to the whole frame).
}
\examples{
data(butterfly)
clus<-kevclus(butterfly,c=2)
print(clus$mass)
clus1<-normalize.credpart(clus,"d") # Dempster normalization
print(clus1$mass)
clus2<-normalize.credpart(clus,"y") # Yager normalization
print(clus2$mass)

}
\references{
T. Denoeux and O. Kanjanatarakul. Beyond Fuzzy, Possibilistic and Rough: An
Investigation of Belief Functions in Clustering. 8th International conference on soft
methods in probability and statistics, Rome, 12-14 September, 2016.
}
\seealso{
\code{\link{extractMass}}, \code{\link{plot.credpart}}, \code{\link{summary.credpart}}.
}
