% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bootclus.R
\name{bootclus}
\alias{bootclus}
\title{Generating a credal partition by bootstraping Gaussian Mixture Models}
\usage{
bootclus(
  x,
  conf = 0.9,
  B = 500,
  param = list(G = NULL),
  type = "pairs",
  Omega = FALSE
)
}
\arguments{
\item{x}{attribute matrix or data frame of size (n,p).}

\item{conf}{confidence level (default: 0.90).}

\item{B}{number of bootstrap samples (default=500)}

\item{param}{list of arguments passed to function \code{Mclust} in addition to 'data'.}

\item{type}{Type of focal sets ("simple": \eqn{\emptyset}, singletons and \eqn{\Omega};
"full": all \eqn{2^c} subsets of \eqn{\Omega}; "pairs": \eqn{\emptyset}, singletons,
\eqn{\Omega}, and all or selected pairs). Argument passed to \code{makeF}.}

\item{Omega}{Logical. If TRUE, \eqn{\Omega} is a focal set. Default is FALSE. 
Argument passed to \code{makeF}.}
}
\value{
A list with the following components:
\describe{
\item{clus}{An object of class '\code{Mclust}' returned by \code{Mclust}.}
\item{Clus}{An object of class '\code{credpart}' providing the output credal partition.}
\item{CI}{An array of dimension (2,n,n) containing the confidence intervals on pairwise probabilities.}
\item{BelPl}{An array of dimension (2,n,n) containing the pairwise Bel-Pl intervals.}
\item{Time}{A matrix of size (3,5) containing the computing time as returned by function \code{proctime}
for (1) the parameter estimation and bootstrap, (2) the computation fo the quantiles on pairwise 
probabilities, and (3) the computation of the credal partition.}
}
}
\description{
\code{bootclus} generates a credal partition by bootstrapping Gaussian Mixture Models.
}
\details{
This function uses the \code{mclust} package to generate and bootstrap the mixture models.
}
\examples{
## Example with the Faithful geyser data
\dontrun{
data("faithful")
X<-faithful
param=list(G=3)
res.faithful<-bootclus(X,conf=0.90,B=100,param=param)
## Plot the results
plot(res.faithful$Clus,X)
}
}
\references{
T. Denoeux. Calibrated model-based evidential clustering using bootstrapping. 
Information Sciences, Vol. 528, pages 17-45, 2020.
}
\seealso{
\code{\link{ecm}}, \code{\link{recm}},
\code{\link{cecm}}, \code{\link{kevclus}}.
}
