% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sat.R
\name{sat}
\alias{sat}
\title{Functions to model evaluation using satellite}
\usage{
sat(
  mo,
  ob,
  rname,
  table = NULL,
  n = 6,
  min = NA,
  max = NA,
  method = "bilinear",
  eval_function = stat,
  mask,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{mo}{SpatRaster or raster with model}

\item{ob}{SpatRaster or raster with observations}

\item{rname}{passed to stat}

\item{table}{data.frame to append the results}

\item{n}{number of points from the boundary removed, default is 5}

\item{min}{minimum value cutoff}

\item{max}{maximum value cutoff}

\item{method}{passed to terra::resample}

\item{eval_function}{evaluation function (default is stat)}

\item{mask}{optional SpatVector to mask the results}

\item{verbose}{set TRUE to display additional information}

\item{...}{other arguments passed to stat}
}
\value{
a data.frame
}
\description{
functions to evaluate the spatial performance using satellite
}
\note{
If a YOU DIED error message appears, means you are removing all the valid values using the arguments min or max.

If cate() is used for eval_function, the argument threshold must be included (see example).
}
\examples{
model_o3 <- terra::rast(paste0(system.file("extdata",package="eva3dm"),
                              "/camx_no2.Rds"))
omi_o3   <- terra::rast(paste0(system.file("extdata",package="eva3dm"),
                              "/omi_no2.Rds"))

# generate the statistical indexes
sat(mo = model_o3,ob = omi_o3,rname = 'NO2_statistical')

# generate categorical evaluation using 3.0 as threshold
sat(mo = model_o3,ob = omi_o3,rname = 'NO2_categorical',
    eval_function = cate, threshold = 3.0)

}
