## ----shape---------------------------------------------------------------
# load package
library(eva)

# A naive implementation of the GEV cumulative density function
pgev_naive <- function(q, loc = 0, scale = 1, shape = 1) {
    exp(-(1 + (shape * (q - loc))/scale)^(-1/shape))
}


curve(pgev_naive(1, 0, 1, x), 1e-20, .01, log = "x", n = 1025)
curve(eva:::pgev(1, 0, 1, x), 1e-20, .01, log = "x", n = 1025)

# Similarly for the GPD cdf
pgpd_naive <- function(q, loc = 0, scale = 1, shape = 1) {
    (1 - (1 + (shape * (q - loc))/scale)^(-1/shape))
}

curve(pgpd_naive(1, 0, 1, x), 1e-20, .01, log = "x", n = 1025)
curve(eva:::pgpd(1, 0, 1, x),  1e-20, .01, log = "x", n = 1025)



## ----seqtesting----------------------------------------------------------
data(lowestoft)
gevrSeqTests(lowestoft, method = "ed")

## ----returnlevel, fig.height = 6, fig.width = 7--------------------------

# Make 250 year return level plot using gevr for r = 1 to 10 with the LoweStoft data

data(lowestoft)
result <- matrix(0, 20, 4)
period <- 250

for(i in 1:10) {
  z <- gevrFit(as.matrix(lowestoft[, 1:i]))
  y1 <- gevrRl(z, period, conf = 0.95, method = "delta")
  y2 <- gevrRl(z, period, conf = 0.95, method = "profile")
  result[i, 1] <- i
  result[i, 2] <- y1$Estimate
  result[i, 3:4] <- y1$CI
  result[(i + 10), 1] <- i
  result[(i + 10), 2] <- y2$Estimate
  result[(i + 10), 3:4] <- y2$CI
}

result <- cbind.data.frame(result, c(rep("Delta", 10), rep("Profile", 10)))
colnames(result) <- c("r", "Est", "Lower", "Upper", "Method")
result <- as.data.frame(result)

library(ggplot2)

ggplot(result, aes(x = r, y = Est,)) +
  geom_ribbon(data = result ,aes(ymin = Lower, ymax = Upper), alpha = 0.3) + 
  facet_grid(Method ~ .) + 
  geom_line() +
  geom_point(size = 3) +
  scale_x_continuous(breaks = seq(0, 10, by=1)) + 
  xlab("r") +
  ylab("250 Year Return Level") +
  theme(text = element_text(size=15))


