% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/gevrFit.R
\name{gevrFit}
\alias{gevrFit}
\title{Parameter estimation for the GEVr distribution model}
\usage{
gevrFit(data, method = c("mle", "mps", "pwm"), information = c("expected",
  "observed"), start = NULL)
}
\arguments{
\item{data}{Data should be a matrix from the GEVr distribution.}

\item{method}{Method of estimation - maximum likelihood (mle), probability weighted moments (pwm), and maximum product spacings (mps). Uses mle by default. For \deqn{r > 1}, only mle can be used.}

\item{information}{Whether standard errors should be calculated via observed or expected (default) information. For probability weighted moments, only expected information will be used if possible.}

\item{start}{Option to provide a set of starting parameters to optim; a vector of location, scale, and shape, in that order. Otherwise, the routine attempts to find good starting parameters.}
}
\value{
A list describing the fit, including parameter estimates and standard errors for the mle and mps methods. Returns as a class object 'gevrFit' to be used with diagnostic plots.
#' ## Put these imports here once so it is generated in the NAMESPACE by roxygen ##
}
\description{
This function provides maximum likelihood estimation for the GEVr model, with the option of probability weighted moment and maximum product
spacing estimation for block maxima (GEV1) data.
}
\examples{
x <- rgevr(500, 1, loc = 0.5, scale = 1, shape = 0.3)
result <- gevrFit(x, method = "mps")
}

