% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/infos.R
\name{et_info}
\alias{et_info}
\title{Informationen zu einer Ertragstafel}
\usage{
et_info(art)
}
\arguments{
\item{art}{Baumartenbezeichnung entweder als Kürzel, deutscher Name,
lateinischer Name oder in niedersächsischer Kodierung.
Für vorhandene Arten siehe \code{\link[=et_liste]{et_liste()}}.}
}
\value{
Informationen zu einer Tafel als Liste mit den Elementen \code{Tafelname},
\code{Baumart}, \code{WissName}, \code{ArtCodeNds}, \code{Autor}, \code{Jahr}, \code{Quelle}, \code{Region}.

\tabular{ll}{
\strong{Kürzel} \tab \strong{Beschreibung}\cr
\code{Tafelname}  \tab Name der Tafel\cr
\code{Baumart}    \tab deutscher Name der Baumart\cr
\code{WissName}   \tab wissenschaftlicher Name der Baumart\cr
\code{ArtCodeNds} \tab Codenummer der niedersächsischen Landesforsten\cr
\code{Autor}      \tab Autor der Tafel\cr
\code{Jahr}       \tab Jahr der Veröffentlichung\cr
\code{Quelle}     \tab Zitat der Tafel\cr
\code{Region}     \tab Gültigkeitsgebiet der Tafel
}
}
\description{
Detaillierte Information zur Ertragstafel einer gewählten Baumart.
}
\examples{
et_info(211)

}
\references{
Albert M., Nagel J., Schmidt M., Nagel R.-V., Spellmann H. (2021): Eine neue
Generation von Ertragstafeln für Eiche, Buche, Fichte, Douglasie und Kiefer
[Datensatz]. Version 1.0. Zenodo. https://doi.org/10.5281/zenodo.6343906
}
\seealso{
\code{\link[=et_liste]{et_liste()}} bietet eine Übersicht aller verfügbaren Tafeln.
}
\author{
Robert Nuske
}
