% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calendar_plot.R
\name{calendar_plot}
\alias{calendar_plot}
\title{Generate a calendar plot}
\usage{
calendar_plot(
  .data,
  timevar = NULL,
  interval = "halfyear",
  week_start = getOption("lubridate.week.start", 1),
  weight_heights = NULL
)
}
\arguments{
\item{.data}{A dataframe that contains the time variable}

\item{timevar}{The time variable name}

\item{interval}{Specifies the time interval over which to group and display data in the calendar plot, with options "halfyear" (default) or "year."}

\item{week_start}{When set to 1 (by default), the week starts on Monday, when set to 7, the week starts on Sunday following USA calendar.}

\item{weight_heights}{A list of weights for adjusting the height of individual plots in the output. Default is NULL.}
}
\value{
A ggplot object, a calendar plot.
}
\description{
The 'calendar_plot()' function creates a calendar visualization that displays the number of occurrences of beeps over one or more years in a calendar format.
The function utilizes the 'ggplot2' package to create the calendar plot.
}
\details{
The 'calendar_plot()' function generates a calendar plot where each cell represents a day of the year,
and the color intensity of the cell (and the occurence number if text_count=TRUE) reflects the number of beep occurrences on that day.
This allows for easy identification of patterns and trends in beep occurrences over time.
}
\examples{
if (interactive()) {
  esmdata_sim$sent <- as.POSIXct(esmdata_sim$sent)
  calendar_plot(esmdata_sim, timevar = "sent", interval = "halfyear")
  calendar_plot(esmdata_sim, timevar = "sent", interval = "year")
}

}
