% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_fill.R
\name{signal_fill}
\alias{signal_fill}
\title{Fill NA-gaps of a signal}
\usage{
signal_fill(data, method = "linear")
}
\arguments{
\item{data}{\code{eseis} object, numeric vector or list of objects, 
data set to be processed.}

\item{method}{\code{Character} value, method to use for filling the data 
gap. One out of \code{"linear"} (linear interpolation) and \code{"zeros"} 
(padding with zeros). Default is \code{"linear"}.}
}
\value{
\code{eseis} object, numeric vector or list of objects, 
gap-filled data set(s).
}
\description{
This function performs linear interpolation of NA values or pads them 
with zeros.
}
\details{
Note that the procedure will contaminate the signal by artefacts as 
increasingly larger data gaps are filled with interpolated or zero values.
}
\examples{

## create synthetic data set and add NA-gaps
data(rockfall)
x <- rockfall_z[25000:26000]
x_gap <- x
x_gap[100:102] <- NA
x_gap[500:530] <- NA

## fill gaps
y <- signal_fill(data = x_gap)

## plot filled data set
plot(y, type = "l")

## filter both data sets
x <- signal_filter(data = x, f = c(1, 3), dt = 1/200, lazy = TRUE)
y <- signal_filter(data = y, f = c(1, 3), dt = 1/200, lazy = TRUE)

## plot both data sets
plot(y, type = "l", col = "grey", lwd = 3)
lines(x, col = "red")

}
\author{
Michael Dietze
}
\keyword{eseis}
