% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_integrate.R
\name{signal_integrate}
\alias{signal_integrate}
\title{Integrate a seismic signal}
\usage{
signal_integrate(data, dt, method = "fft", waterlevel = 10^-6)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{dt}{\code{Numeric} scalar, sampling rate.}

\item{method}{\code{Character} scalar, method used for integration. One out 
of \code{"fft"} (convert in the frequency domain) and \code{"trapezoid"} 
(integrate using the trapezoidal rule). Default is \code{"fft"}.}

\item{waterlevel}{\code{Numeric} scalar, waterlevel value for frequency
division, default is \code{10^-6}. Only used when \code{method = "fft"}.}
}
\value{
\code{Numeric} vector or list of vectors, integrated signal.
}
\description{
The function integrates a signal vector to convert values from velocity to 
displacement. Two methods are available
}
\examples{

## load example data set
data(rockfall)

## deconvolve signal
rockfall_decon <- signal_deconvolve(data = rockfall_eseis)
                                    
## integrate signal
rockfall_int <- signal_integrate(data = rockfall_decon)
                                 
## Note that usually the signal should be filtered prior to integration.
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
