% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/signal_envelope.R
\name{signal_envelope}
\alias{signal_envelope}
\title{Calculate signal envelope.}
\usage{
signal_envelope(data, p = 0)
}
\arguments{
\item{data}{\code{eseis} object, \code{numeric} vector or list of 
objects, data set to be processed.}

\item{p}{\code{Numeric} value, proportion of the signal to be tapered,
default is \code{0}.}
}
\value{
\code{Numeric} vector or list of vectors, signal envelope.
}
\description{
The function calculates envelopes of the input signals as 
cosine-tapered envelope of the Hilbert-transformed signal. The signal
should be detrended and/or the mean should be removed before processing.
}
\examples{

## load example data set
data(rockfall)

## detrend data set
rockfall_detrend <- signal_detrend(data = rockfall_eseis)

## calculate envelope
rockfall_envelope <- signal_envelope(data = rockfall_detrend)

## plot envelope
plot_signal(data = rockfall_envelope)
                     
}
\author{
Michael Dietze
}
\keyword{eseis}
