% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_rdiff_two.R
\name{estimate_rdiff_two}
\alias{estimate_rdiff_two}
\title{Estimates the difference in correlation for a design with two groups and
two continuous outcome variables}
\usage{
estimate_rdiff_two(
  data = NULL,
  x = NULL,
  y = NULL,
  grouping_variable = NULL,
  comparison_r = NULL,
  comparison_n = NULL,
  reference_r = NULL,
  reference_n = NULL,
  grouping_variable_levels = NULL,
  x_variable_name = "My x variable",
  y_variable_name = "My y variable",
  grouping_variable_name = "My grouping variable",
  conf_level = 0.95,
  save_raw_data = TRUE
)
}
\arguments{
\item{data}{For raw data - a dataframe or tibble}

\item{x}{For raw data - The column name of the outcome
variable, or a vector of numeric data}

\item{y}{For raw data - The column name of the outcome
variable, or a vector of numeric data}

\item{grouping_variable}{For raw data, a vector that is a factor or the
name of a factor column from data}

\item{comparison_r}{For summary data, a pearson's r correlation coefficient}

\item{comparison_n}{For summary data - An integer > 0}

\item{reference_r}{For summary data, a pearson's r correlation coefficient}

\item{reference_n}{For summary data - An integer > 0}

\item{grouping_variable_levels}{For summary data - An optional vector of
2 group labels}

\item{x_variable_name}{Optional friendly name for the x variable.
Defaults to 'My x variable' or the outcome variable column name if a
data frame is passed.}

\item{y_variable_name}{Optional friendly name for the y variable.
Defaults to 'My y variable' or the outcome variable column name if a
data frame is passed.}

\item{grouping_variable_name}{Optional friendly name for the grouping
variable.  Defaults to 'My grouping variable' or the grouping variable
column name if a data.frame is passed.}

\item{conf_level}{The confidence level for the confidence interval.  Given in
decimal form.  Defaults to 0.95.}

\item{save_raw_data}{For raw data; defaults to TRUE; set to FALSE to save
memory by not returning raw data in estimate object}
}
\value{
Returns object of class esci_estimate
\itemize{
\item \strong{overview}
\itemize{
\item \emph{outcome_variable_name} -
\item \emph{grouping_variable_name} -
\item \emph{grouping_variable_level} -
\item \emph{mean} -
\item \emph{mean_LL} -
\item \emph{mean_UL} -
\item \emph{median} -
\item \emph{median_LL} -
\item \emph{median_UL} -
\item \emph{sd} -
\item \emph{min} -
\item \emph{max} -
\item \emph{q1} -
\item \emph{q3} -
\item \emph{n} -
\item \emph{missing} -
\item \emph{df} -
\item \emph{mean_SE} -
\item \emph{median_SE} -
}
\item \strong{es_r_difference}
\itemize{
\item \emph{type} -
\item \emph{grouping_variable_name} -
\item \emph{grouping_variable_level} -
\item \emph{x_variable_name} -
\item \emph{y_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{n} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
\item \emph{rz} -
\item \emph{sem} -
\item \emph{z} -
\item \emph{p} -
}
\item \strong{es_r}
\itemize{
\item \emph{grouping_variable_name} -
\item \emph{grouping_variable_level} -
\item \emph{x_variable_name} -
\item \emph{y_variable_name} -
\item \emph{effect} -
\item \emph{effect_size} -
\item \emph{LL} -
\item \emph{UL} -
\item \emph{SE} -
\item \emph{n} -
\item \emph{df} -
\item \emph{ta_LL} -
\item \emph{ta_UL} -
}
\item \strong{raw_data}
\itemize{
\item \emph{x} -
\item \emph{y} -
\item \emph{grouping_variable} -
}
}
}
\description{
Returns object
\code{estimate_rdiff_two} is suitable for a simple two-group design
with two continuous outcome variables where you want to estimate the
difference in the strength of the relationship between the two groups.
It estimate the linear correlation (Pearson's r) for each group and the
difference in r, along with confidence intervals.  You can
pass raw data or summary data.

Returns effect sizes appropriate for estimating the linear relationship
between two quantitative variables
}
\details{
Once you generate an estimate with this function, you can visualize
it with \code{\link[=plot_rdiff]{plot_rdiff()}} and you can test hypotheses with
\code{\link[=test_rdiff]{test_rdiff()}}.  In addition, you can use \code{\link[=plot_scatter]{plot_scatter()}}
to visualize the raw data.

The estimated single-group r values are from \code{\link[statpsych:ci.cor]{statpsych::ci.cor()}}.

The difference in r values is from \code{\link[statpsych:ci.cor2]{statpsych::ci.cor2()}}.
}
\examples{
# From raw data
data("data_campus_involvement")

estimate_from_raw <- esci::estimate_rdiff_two(
  esci::data_campus_involvement,
  GPA,
  SWB,
  Gender
)

# To visualize the difference in r
myplot_from_raw <- esci::plot_rdiff(estimate_from_raw)

# To visualize the data (scatterplot) by group
myplot_scatter <- esci::plot_scatter(estimate_from_raw)

# To evaluate a hypothesis (by default: point null of exaclty 0):
res_htest_from_raw <- esci::test_rdiff(
  estimate_from_raw
)


# From summary data
estimate <- esci::estimate_rdiff_two(
  comparison_r = .53,
  comparison_n = 45,
  reference_r = .41,
  reference_n = 59,
  grouping_variable_levels = c("Females", "Males"),
  x_variable_name = "Satisfaction with life",
  y_variable_name = "Body satisfaction",
  grouping_variable_name = "Gender",
  conf_level = .95
)

myplot_from_summary <- esci::plot_rdiff(estimate)

# To evaluate a hypothesis (interval null from -0.1 to 0.1):
res_htest_from_summary <- esci::test_rdiff(
  estimate,
  rope = c(-0.1, 0.1)
)


}
