% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stop_when_tox_ci_covered.R
\name{stop_when_tox_ci_covered}
\alias{stop_when_tox_ci_covered}
\title{Stop when uncertainty interval of prob tox is covered.}
\usage{
stop_when_tox_ci_covered(
  parent_selector_factory,
  dose,
  lower,
  upper,
  width = 0.9
)
}
\arguments{
\item{parent_selector_factory}{Object of type \code{\link{selector_factory}}.}

\item{dose}{\code{'any'} to stop when the interval for any dose is covered;
\code{'recommended'} to stop when the interval for the recommended dose is
covered ; or an integer to stop when the interval for a particular dose-level
is covered.}

\item{lower}{Stop when lower interval bound exceeds this value}

\item{upper}{Stop when upper interval bound is less than this value}

\item{width}{Width of the uncertainty interval. Default is 0.9, i.e. a range
from the 5th to the 95th percentiles.}
}
\value{
an object of type \code{\link{selector_factory}} that can fit a
dose-finding model to outcomes.
}
\description{
This method stops a dose-finding trial when the symmetric uncertainty
interval for the probability of toxicity falls within a range. This allows
trials to be stopped when sufficient precision on the pobability of toxicity
has been achieved. See Details.
}
\details{
The method for calculating probability mass for toxicity rates will
ultimately be determined by the dose-finding model used and the attendant
inferential mechanism. For instance, the \code{\link[dfcrm]{crm}} function in
the dfcrm package calculates the posterior expected mean and variance of the
slope parameter in a CRM model. It does not use MCMC to draw samples from the
posterior distribution. Thus, to perform inference on the posterior
probability of toxicity, this package assumes the dfcrm slope parameter
follows a normal distribution with the mean and variance calculated by dfcrm.
In contrast, the \code{stan_crm} function in the \code{trialr}
package needs no such assumption because it samples from the posterior
parameter distribution and uses those samples to infer on the posterior
probability of toxicity at each dose, dependent on the chosen model for the
dose-toxicity curve.
}
\examples{
skeleton <- c(0.05, 0.1, 0.25, 0.4, 0.6)
target <- 0.25

# We compare a CRM model without this stopping rule:
model1 <- get_dfcrm(skeleton = skeleton, target = target)
# To two with it, the first demanding a relatively tight CI:
model2 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_when_tox_ci_covered(dose = 'recommended', lower = 0.15, upper = 0.35)
# and the second demanding a relatively loose CI:
model3 <- get_dfcrm(skeleton = skeleton, target = target) \%>\%
  stop_when_tox_ci_covered(dose = 'recommended', lower = 0.05, upper = 0.45)

outcomes <- '1NNN 2NNN 3NNT 3NNN 3TNT 2NNN'
fit1 <- model1 \%>\% fit(outcomes)
fit2 <- model2 \%>\% fit(outcomes)
fit3 <- model3 \%>\% fit(outcomes)

# Naturally the first does not advocate stopping:
fit1 \%>\% recommended_dose()
fit1 \%>\% continue()

# The second does not advocate stopping either:
fit2 \%>\% recommended_dose()
fit2 \%>\% continue()
# This is because the CI is too wide:
fit2 \%>\% prob_tox_quantile(p = 0.05)
fit2 \%>\% prob_tox_quantile(p = 0.95)

# However, the third design advocates stopping because the CI at the
# recommended dose is covered:
fit3 \%>\% recommended_dose()
fit3 \%>\% continue()
# To verify the veracity, inspect the quantiles:
fit3 \%>\% prob_tox_quantile(p = 0.05)
fit3 \%>\% prob_tox_quantile(p = 0.95)
}
