% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check-class.R
\name{check_class}
\alias{check_class}
\title{Check Argument's Class}
\usage{
check_class(
  x,
  valid,
  name = NULL,
  general = NULL,
  specific = NULL,
  supplement = NULL,
  ...
)
}
\arguments{
\item{x}{The argument to check, which can be any object.}

\item{valid}{A character vector which contains valid classes.}

\item{name}{A single character which gives the argument's name.
The name is used in the error message. By default, the name of the
argument passed to argument \code{x} is captured automatically.}

\item{general}{Optional. A single character which is used to give a
general statement of the error incurred. By default, this is generated
automatically.}

\item{specific}{Optional. A single character which gives a detailed
description of the error. \code{\link[glue:glue]{glue::glue()}} syntax can be used, see
"Examples" section. By default, this is generated automatically.}

\item{supplement}{Optional. A (named) character vector which gives some
additional information about the error. The names are used to create
bullets, see \code{\link[=throw]{throw()}}. By default, this is left empty.}

\item{...}{Optional. Additional arguments which can be retrieved with
\code{\link[=tryCatch]{tryCatch()}}.}
}
\value{
returns an invisible \code{NULL} if the argument is valid, or
generates an error message.
}
\description{
Check if an argument has valid class, and if not,
generate an error message.
}
\examples{
x <- 1
class(x) <- c("a", "b")

check_class(x, c("a", "c"))

\dontrun{
check_class(x, c("c", "d"))

# customize error message with `glue::glue()` syntax
specific <- "Unbelievable! The first class of `{name}` is {feature[1]}."
check_class(x, c("c", "d"), specific = specific)
}
}
\seealso{
"Examples" section in \code{\link[=check_type]{check_type()}} for how to customize
error message and how to add and retrieve additional arguments.

\code{vignette("erify")} for a gentle introduction to this package.
}
