% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.ergm.R, R/print.summary.ergm.R
\name{summary.ergm}
\alias{summary.ergm}
\alias{print.summary.ergm}
\title{Summarizing ERGM Model Fits}
\usage{
\method{summary}{ergm}(
  object,
  ...,
  correlation = FALSE,
  covariance = FALSE,
  total.variation = TRUE
)

\method{print}{summary.ergm}(
  x,
  digits = max(3, getOption("digits") - 3),
  correlation = x$correlation,
  covariance = x$covariance,
  signif.stars = getOption("show.signif.stars"),
  eps.Pvalue = 1e-04,
  print.formula = FALSE,
  print.fitinfo = TRUE,
  print.coefmat = TRUE,
  print.message = TRUE,
  print.deviances = TRUE,
  print.drop = TRUE,
  print.offset = TRUE,
  print.call = TRUE,
  ...
)
}
\arguments{
\item{object}{an object of class "ergm", usually, a result of a call to
\code{\link[=ergm]{ergm()}}.}

\item{...}{For \code{\link[=summary.ergm]{summary.ergm()}} additional arguments are passed to
\code{\link[=logLik.ergm]{logLik.ergm()}}. For \code{\link[=print.summary.ergm]{print.summary.ergm()}}, to \code{\link[stats:printCoefmat]{stats::printCoefmat()}}.}

\item{correlation}{logical; if \code{TRUE}, the correlation matrix of the
estimated parameters is returned and printed.}

\item{covariance}{logical; if \code{TRUE}, the covariance matrix of the estimated
parameters is returned and printed.}

\item{total.variation}{logical; if \code{TRUE}, the standard errors reported in
the \verb{Std. Error} column are based on the sum of the likelihood variation
and the MCMC variation. If \code{FALSE} only the likelihood variation is used.
The \eqn{p}-values are based on this source of variation.}

\item{x}{object of class \code{summary.ergm} returned by \code{\link[=summary.ergm]{summary.ergm()}}.}

\item{digits}{significant digits for coefficients}

\item{signif.stars}{whether to print dots and stars to signify
statistical significance. See \code{\link[=print.summary.lm]{print.summary.lm()}}.}

\item{eps.Pvalue}{\eqn{p}-values below this level will be printed
as "<\code{eps.Pvalue}".}

\item{print.formula, print.fitinfo, print.coefmat, print.message, print.deviances, print.drop, print.offset, print.call}{which components of the fit summary to print.}
}
\value{
The function \code{\link[=summary.ergm]{summary.ergm()}} computes and returns a list of summary
statistics of the fitted \code{\link[=ergm]{ergm()}} model given in \code{object}. Note that for
backwards compatibility, it returns two coefficient tables: \verb{$coefs} which
does not contain the z-statistics and \verb{$coefficeints} which does (and is
therefore more similar to those returned by \code{\link[stats:summary.lm]{stats::summary.lm()}}).

The returned object is a list of class "ergm.summary" with the following
elements:

\item{formula}{ERGM model formula}
\item{call}{R call used to fit the model}
\item{correlation, covariance}{whether to print correlation/covariance matrices of the estimated parameters}
\item{pseudolikelihood}{was the model estimated with MPLE}
\item{independence}{is the model dyad-independent}
\item{control}{the \code{\link[=control.ergm]{control.ergm()}} object used}
\item{samplesize}{MCMC sample size}
\item{message}{optional message on the validity of the standard error estimates}
\item{null.lik.0}{It is \code{TRUE} of the null model likelihood has not been calculated. See \code{\link[=logLikNull]{logLikNull()}}}
\item{devtext, devtable}{Deviance type and table}
\item{aic, bic}{values of AIC and BIC}
\item{coefs, coefficients}{data frames with model parameters and associated statistics}
\item{asycov}{asymptotic covariance matrix}
\item{asyse}{asymptotic standard error matrix}
\item{offset, drop, estimate, iterations, mle.lik, null.lik}{
see documentation of the object returned by \code{\link[=ergm]{ergm()}}
}
}
\description{
\code{\link[base:summary]{base::summary()}} method for \code{\link[=ergm]{ergm()}} fits.
}
\details{
\code{\link[=summary.ergm]{summary.ergm()}} tries to be smart about formatting the
coefficients, standard errors, etc.

The default printout of the summary object contains the call, number
of iterations used, null and residual deviances, and the values of AIC and
BIC. The coeficient table contains the following columns:
\itemize{
\item \code{Estimate}, \verb{Std. Error} - parameter estimates and their standard errors
\item \verb{MCMC \%} - if \code{total.variation=TRUE} (default) the percentage of standard
error attributable to MCMC estimation process rounded to an integer. See
also \code{\link[=vcov.ergm]{vcov.ergm()}} and its \code{sources} argument.
\item \verb{z value}, \verb{Pr(>|z|)} - z-test and p-values
}
}
\examples{

 data(florentine)

 x <- ergm(flomarriage ~ density)
 summary(x)

}
\seealso{
The model fitting function \code{\link[=ergm]{ergm()}}, \code{\link[=print.ergm]{print.ergm()}}, and
\code{\link[base:summary]{base::summary()}}. Function \code{\link[stats:coef]{stats::coef()}} will extract the data frame of
coefficients with standard errors, t-statistics and p-values.
}
\keyword{models}
\keyword{regression}
