% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/processATC.R
\name{filterNeuroDrugs}
\alias{filterNeuroDrugs}
\title{Filter a given list of drug names for having an ATC code starting with N indicating to be a 
drug for the Nervous System}
\usage{
filterNeuroDrugs(druglist, atchashda)
}
\arguments{
\item{druglist}{a list of drug names}

\item{atchashda}{a hash containing the drug names as keys}
}
\value{
neurodrugs a hash filtered for having an ATC code starting with N
}
\description{
Filter a given list of drug names for having an ATC code starting with N indicating to be a 
drug for the Nervous System
}
\examples{
utils::data(rawDrugBankCoOcEpSO, package="epos")
atchashda <-
  readAtcMapIntoHashMapDrugNamesAtcCodes(
  system.file("extdata", "db-atc.map", package = "epos"), "\\t")
tepso <- genDictListFromRawFreq(rawDrugBankCoOcEpSO)
nepso <- filterNeuroDrugs(tepso, atchashda)
}
