% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/geo-tagging.R
\name{update_geonames}
\alias{update_geonames}
\title{Updates the local copy of the GeoNames database}
\usage{
update_geonames(tasks = get_tasks())
}
\arguments{
\item{tasks}{Tasks object for reporting progress and error messages, default: get_tasks()}
}
\value{
The list of tasks updated with produced messages
}
\description{
Downloading and indexing a fresh version of the GeoNames database from the provided URL
}
\details{
Run a one shot task to download and index a local copy of the  \href{http://www.geonames.org/}{GeoNames database}. 
The GeoNames geographical database covers all countries and contains over eleven million place names that are available; Creative Commons Attribution 4.0 License. 

The URL to download the database from is set on the configuration tab of the Shiny app, in case it changes.

The indexing is developed in Spark and Lucene

A prerequisite to this function is that the \code{\link{search_loop}} must already have stored collected tweets in the search folder and that the task \code{\link{download_dependencies}}
has been successfully run.

Normally this function is not called directly by the user but from the \code{\link{detect_loop}} function.
}
\examples{
if(FALSE){
   library(epitweetr)
   # setting up the data folder
   message('Please choose the epitweetr data directory')
   setup_config(file.choose())

   # geolocating last tweets
   tasks <- update_geonames()
}
}
\seealso{
\code{\link{download_dependencies}}

 \code{\link{detect_loop}}

 \code{\link{get_tasks}}
}
