% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stratified_risk.R
\name{stratified_risk}
\alias{stratified_risk}
\title{Stratified risk}
\usage{
stratified_risk(data, exposure, outcome, stratifier, ci_level = 95)
}
\arguments{
\item{data}{A dataframe providing the exposure, outcome and stratifying variable}

\item{exposure}{binary variable giving the exposure status}

\item{outcome}{binary variable giving the outcome status}

\item{stratifier}{stratifying variable}

\item{ci_level}{variable giving the limits for the confidence interval}
}
\value{
A dataframe giving an MH-adjusted risk ratio
}
\description{
Calculate stratified risk estimates as per Chapter 15,
}
\examples{
data(tolbutamide)
stratified_risk(tolbutamide, exposure = tolbutamide, outcome = dead,
    stratifier = age)
}
