% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/epiparameter-utils.R
\name{create_metadata}
\alias{create_metadata}
\title{Specify metadata associated with data set}
\usage{
create_metadata(
  units = NA_character_,
  sample_size = NA_integer_,
  region = NA_character_,
  transmission_mode = NA_character_,
  vector = NA_character_,
  extrinsic = FALSE,
  inference_method = NA_character_
)
}
\arguments{
\item{units}{A \code{character} for the units of the epidemiological parameter.}

\item{sample_size}{The sample of the data used to fit the delay distribution.
This is usually the number of people with data on a primary and possibly
secondary event of interest. In cases where the sample size is not stated
NA can be used.}

\item{region}{The geographical location the data was collected. This can
either be given at sub-national, national, continental. Multiple nested
regions can be given and are comma separated. When the region is not
specified NA can be given.}

\item{transmission_mode}{A character string specifying how the pathogen is
transmitted. This information is used to determine whether the
epidemiological parameters are from a vector-borne disease (i.e. is
transmitted between humans through an intermediate vector), this is specified
by \code{transmission_mode = "vector_borne"}.}

\item{vector}{The name of the vector transmitting the vector-borne disease.
This can be a common name, or a latin binomial name of a specific vector
species. Both the common name and taxonomic name can be given with one given
in parentheses. When a disease is not vector-borne NA should be given.}

\item{extrinsic}{A boolean value defining whether the data entry is an
extrinsic delay distribution, such as the extrinsic incubation period.
This field is required because intrinsic and extrinsic delay distributions
are stored as separate entries in the database and can be linked.
When the disease is not vector-borne FALSE should be given. See Details for
explanation of extrinsic distribution.}

\item{inference_method}{The type of inference used to fit the delay
distribution to the data. Abbreviations of model fitting techniques can be
specified as long as they are non-ambiguous. This field is only used to
determine whether the uncertainty intervals possibly specified in the other
fields are: confidence intervals (in the case of maximum likelihood), or
credible intervals (in the case of bayesian inference). Uncertainty bounds
for another types of inference methods, or if the inference method is
unstated are assumed to be confidence intervals. When the inference method
is unknown or a disease does not have a probability distribution NA can be
given.}
}
\value{
A named list containing information on the sample size of the study,
geography, whether the disease is vector-borne and if so whether it is the
intrinsic or extrinsic distribution as well as method of distribution
parameter estimation.
}
\description{
A helper function when creating an \verb{<epiparameter>} object to
create a metadata list with sensible defaults, type checking and arguments
to help remember metadata list structure (element names).
}
\details{
In vector-borne diseases the transmissibility of a disease is
dependent on both the time taken for a host (i.e. human) to become
infectious, but also on the time it takes the vector to become infectious.
Therefore, the extrinsic delay, in which the vector has been infected by is
not yet infectious can have a role in the spread of a disease.
}
\examples{
# it will automatically populate the fields with defaults if left empty
create_metadata()

# supplying each field
create_metadata(
  units = "days",
  sample_size = 10,
  region = "UK",
  transmission_mode = "vector_borne",
  vector = "mosquito",
  extrinsic = FALSE,
  inference_method = "MLE"
)
}
