% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/convert_params.R
\name{convert_params_to_summary_stats}
\alias{convert_params_to_summary_stats}
\alias{convert_params_to_summary_stats.character}
\alias{convert_params_to_summary_stats.epiparameter}
\title{Convert the parameter(s) of a distribution to summary statistics}
\usage{
convert_params_to_summary_stats(x, ...)

\method{convert_params_to_summary_stats}{character}(
  x = c("lnorm", "gamma", "weibull", "nbinom", "geom"),
  ...
)

\method{convert_params_to_summary_stats}{epiparameter}(x, ...)
}
\arguments{
\item{x}{An \R object.}

\item{...}{<\code{\link[rlang:dyn-dots]{dynamic-dots}}> \code{Numeric} named parameter(s)
used to convert to summary statistics. An example is the \code{meanlog} and
\code{sdlog} parameters of the lognormal (\code{lnorm}) distribution.}
}
\value{
A list of eight elements including: mean, median, mode,
variance (\code{var}), standard deviation (\code{sd}), coefficient of variation (\code{cv}),
skewness, and excess kurtosis (\code{ex_kurtosis}).
}
\description{
Convert the parameters for a range of distributions to a
number of summary statistics. All summary statistics are calculated
analytically given the parameters.
}
\details{
The distribution names and parameter names follow the style of
distributions in \R, for example the lognormal distribution is \code{lnorm},
and its parameters are \code{meanlog} and \code{sdlog}.
}
\examples{
# example using characters
convert_params_to_summary_stats("lnorm", meanlog = 1, sdlog = 2)
convert_params_to_summary_stats("gamma", shape = 1, scale = 1)
convert_params_to_summary_stats("nbinom", prob = 0.5, dispersion = 2)

# example using <epiparameter>
epiparameter <- epiparameter_db(single_epiparameter = TRUE)
convert_params_to_summary_stats(epiparameter)

# example using <epiparameter> and specifying parameters
epiparameter <- epiparameter_db(
  disease = "Influenza",
  author = "Virlogeux",
  subset = prob_dist == "weibull"
)
convert_params_to_summary_stats(epiparameter[[2]], shape = 1, scale = 1)
}
\seealso{
\code{\link[=convert_summary_stats_to_params]{convert_summary_stats_to_params()}}
}
