% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.R
\name{calc_disc_dist_quantile}
\alias{calc_disc_dist_quantile}
\title{Calculate the quantiles of a probability distribution based on the vector
of probabilities and time data (e.g. time since infection)}
\usage{
calc_disc_dist_quantile(prob, days, quantile)
}
\arguments{
\item{prob}{A \code{numeric} vector of probabilities.}

\item{days}{A \code{numeric} vector of days.}

\item{quantile}{A single \code{numeric} or vector of \code{numerics} specifying which
quantiles to extract from the distribution.}
}
\value{
A named vector of quantiles.
}
\description{
This function can be used in cases where the data on a fitted
distribution is not openly available and the summary statistics of the
distribution are not reported so the data are scraped from the plot and
the quantiles are needed in order use the \code{\link[=extract_param]{extract_param()}} function.
}
\examples{
prob <- dgamma(seq(0, 10, length.out = 21), shape = 2, scale = 2)
days <- seq(0, 10, 0.5)
quantiles <- c(0.025, 0.975)
calc_disc_dist_quantile(prob = prob, days = days, quantile = quantiles)
}
