% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/otherTempExtremes.R
\name{otherTempExtremes}
\alias{otherTempExtremes}
\title{Temperature Extremes}
\usage{
otherTempExtremes(meantempStack, mintempStack, maxtempStack)
}
\arguments{
\item{meantempStack}{rasterStack of monthly mean temperature}

\item{mintempStack}{rasterStack of monthly min temperature}

\item{maxtempStack}{rasterStack of monthly max temperature}
}
\value{
rasterStack of maxTempColdest, minTempWarmest, meanTempColdest, meanTempWarmest, in 
same units as input rasters.
}
\description{
Generates max temp of the coldest month, min temp of the warmest month, mean temp
of the coldest month, mean temp of the warmest month.
}
\examples{
\dontrun{
# Find example rasters
rasterFiles <- list.files(system.file('extdata', package='envirem'), full.names=TRUE)
env <- stack(rasterFiles)

# identify appropriate layers
tmean <- grep('tmean', names(env))
tmin <- grep('tmin', names(env))
tmax <- grep('tmax', names(env))

tmean <- env[[tmean]]
tmin <- env[[tmin]]
tmax <- env[[tmax]]

# calculate temperature extremes
otherTempExtremes(tmean, tmin, tmax)
}
}
\author{
Pascal Title
}
