% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generateRasters.R
\name{generateRasters}
\alias{generateRasters}
\title{Execute Layer Creation}
\usage{
generateRasters(var, maindir, resName, timeName, outputDir,
  rasterExt = ".tif", nTiles = 1, overwriteResults = TRUE,
  outputFormat = "GTiff", tempDir = "~/temp", gdalinfoPath = NULL,
  gdal_translatePath = NULL)
}
\arguments{
\item{var}{a vector of variable names to generate, see Details.}

\item{maindir}{path to directory of input rasters}

\item{resName}{output nametag for the resolution}

\item{timeName}{output nametag for the time period}

\item{outputDir}{output directory. A directory will be generated according 
to the resName and timeName, so this is the output location for the 
directory that will be generated.}

\item{rasterExt}{the file extension of the input rasters}

\item{nTiles}{the number of tiles to split the rasters when 
tiling is requested, must be a perfect square}

\item{overwriteResults}{logical, should existing rasters be overwritten}

\item{outputFormat}{output format for rasters, see \code{\link{writeRaster}} for options}

\item{tempDir}{temporary directory that will be created and then removed}

\item{gdalinfoPath}{path to gdalinfo binary, leave as \code{NULL} if it is in the default search path.}

\item{gdal_translatePath}{path to gdal_translate binary, leave as \code{NULL} if it is in the default search path.}
}
\value{
The requested set of rasterLayers will be written to \code{outputDir}.
}
\description{
Main function to generate specified ENVIREM layers.
If requested, this function will split input rasters into tiles, generate desired variables,
and reassemble the results. Results are named according to specified resName and timeName. 
For the distinction between this function and \code{\link{layerCreation}}, 
see \code{Details}.
}
\details{
The function \code{\link{layerCreation}} will generate envirem rasters from input R 
objects (rasterStacks) and will return the result as an R object. In contrast, 
the function \code{generateRasters} reads in input rasters from a specified directory, 
splits input rasters into tiles if necessary, internally calls 
\code{\link{layerCreation}} and writes the result to file. 

Possible variables to generate include:\cr
\cr
annualPET \cr
aridityIndexThornthwaite \cr
climaticMoistureIndex \cr
continentality \cr
embergerQ \cr
growingDegDays0 \cr
growingDegDays5 \cr
maxTempColdest \cr
minTempWarmest \cr
monthCountByTemp10 \cr
PETColdestQuarter \cr
PETDriestQuarter \cr
PETseasonality \cr
PETWarmestQuarter \cr
PETWettestQuarter \cr
thermicityIndex \cr

If \code{var = 'all'}, then all of the variables will be generated.

\code{resName} and \code{timeName} are only used for naming the output directory.

Rasters in \code{mainDir} should be named appropriately (see \code{\link{verifyFileStructure}})
and with identical resolution, origin and extent. 

Output rasters are written with the most appropriate \code{\link{dataType}}, as 
inferred with \code{\link{dataTypeCheck}}. This will reduce the file size of these rasters. 

If the goal is to use these rasters with the standalone Maxent program, we recommend 
\code{outputFormat = 'EHdr'}.
}
\author{
Pascal Title
}
\seealso{
Naming of rasters in inputDir will be checked with \code{\link{verifyFileStructure}}.
}

