% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getmzrt.R
\name{getcsv}
\alias{getcsv}
\title{Convert an list object to csv file.}
\usage{
getcsv(list, name, mzdigit = 4, rtdigit = 1, type = "o", ...)
}
\arguments{
\item{list}{list with data as peaks list, mz, rt and group information}

\item{name}{result name for csv and/or eic file, default NULL}

\item{mzdigit}{m/z digits of row names of data frame, default 4}

\item{rtdigit}{retention time digits of row names of data frame, default 1}

\item{type}{csv formate for furthor analysis, m means  Metaboanalyst, a means xMSannotator, p means Mummichog(NA values are imputed by `getimputation`, and F test is used here to generate stats and p vlaue), o means full infomation csv (for `pmd` package), default o. mapo could output all those format files.}

\item{...}{other parameters for `write.table`}
}
\value{
NULL, csv file
}
\description{
Convert an list object to csv file.
}
\examples{
\dontrun{
data(list)
getcsv(list,name='demo')
}
}
\references{
Li, S.; Park, Y.; Duraisingham, S.; Strobel, F. H.; Khan, N.; Soltow, Q. A.; Jones, D. P.; Pulendran, B. PLOS Computational Biology 2013, 9 (7), e1003123.
Xia, J., Sinelnikov, I.V., Han, B., Wishart, D.S., 2015. MetaboAnalyst 3.0—making metabolomics more meaningful. Nucl. Acids Res. 43, W251–W257.
}
