% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pln.R
\name{pln}
\alias{pln}
\title{Poisson Lognormal Model}
\usage{
pln(
  form,
  data = NULL,
  par = NULL,
  method = "BFGS",
  init = c("zero", "unif", "norm", "default")[4],
  H = 20,
  verbose = 0
)
}
\arguments{
\item{form}{Formula}

\item{data}{Input data, a data frame}

\item{par}{Starting values for estimates}

\item{method}{Optimization algorithm.}

\item{init}{Initialization method}

\item{H}{Number of quadrature points}

\item{verbose}{A integer indicating how much output to display during the estimation process.
\itemize{
\item <0 - No ouput
\item 0 - Basic output (model estimates)
\item 1 - Moderate output, basic ouput + parameter and likelihood in each iteration
\item 2 - Extensive output, moderate output + gradient values on each call
}}
}
\value{
A list containing the results of the estimated model, some of which are inherited from the return of maxLik
\itemize{
\item estimates: Model estimates with 95\% confidence intervals
\item estimate or par: Point estimates
\item variance_type: covariance matrix used to calculate standard errors. Either BHHH or Hessian.
\item var: covariance matrix
\item se: standard errors
\item gradient: Gradient function at maximum
\item hessian: Hessian matrix at maximum
\item gtHg: \eqn{g'H^-1g}, where H^-1 is simply the covariance matrix. A value close to zero (e.g., <1e-3 or 1e-6) indicates good convergence.
\item LL or maximum: Likelihood
\item AIC: AIC
\item BIC: BIC
\item n_obs: Number of observations
\item n_par: Number of parameters
\item LR_stat: Likelihood ratio test statistic for the heterogeneity term \eqn{\lambda=0}
\item LR_p: p-value of likelihood ratio test
\item iterations: number of iterations taken to converge
\item message: Message regarding convergence status.
}

Note that the list inherits all the components in the output of maxLik. See the documentation of maxLik for more details.
}
\description{
Estimate a Poisson model with a log-normally distributed heterogeneity term, which is also referred to as the Poisson-Normal model.\cr\cr
\deqn{E[y_i|x_i,u_i]=exp(\boldsymbol{\alpha}'\mathbf{x_i}+\lambda u_i)}{E[y_i | x_i, u_i] = exp(\alpha' * x_i + \lambda * u_i)}
The estimates of this model are often similar to those of a negative binomial model.
}
\examples{
library(MASS)
N = 2000
set.seed(1)

# Works well when the variance of the normal term is not overly large
# When the variance is very large, it tends to be underestimated
x = rbinom(N, 1, 0.5)
z = rnorm(N)
y = rpois(N, exp(-1 + x + z + 0.5 * rnorm(N)))
est = pln(y~x+z)
print(est$estimates, digits=3)
}
\references{
Peng, Jing. (2023) Identification of Causal Mechanisms from Randomized Experiments: A Framework for Endogenous Mediation Analysis. Information Systems Research, 34(1):67-84. Available at https://doi.org/10.1287/isre.2022.1113
}
