% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc.R
\name{dbnorm}
\alias{dbnorm}
\title{Function to dB-normalise spectral objects}
\usage{
dbnorm(specdata, f = 0, db = 0)
}
\arguments{
\item{specdata}{An object of class 'spectral'}

\item{f}{A single element vector specifying the frequency. Defaults to 0}

\item{db}{A single element vector specifying the dB value to which the
spectrum is to be rescaled. Defaults to zero}
}
\value{
An object of the same class with rescaled dB values. The default is
to rescale the dB-values of the spectrum to 0 dB at 0 Hz.
}
\description{
The function can be used to rescale a spectrum to a dB value at a
particular frequency - for example, to rescale the spectrum so that 3000 Hz
has 0 dB and all other values are shifted in relation to this.
}
\examples{

# normalise to - 40 dB at 1500 Hz
res = dbnorm(e.dft, 1500, 0)
# compare the two
ylim = range(c(res, e.dft))
plot(e.dft, ylim=ylim, type="l")
par(new=TRUE)
plot(res, ylim=ylim, type="l", col=2)


}
\seealso{
\code{\link{dbtopower}} \code{\link{plot.spectral}}
}
\author{
Jonathan Harrington
}
\keyword{manip}
