\name{generate.trend}
\alias{generate.trend}
\title{
Generates a set of mean values.
}
\description{
This function is used to generate mean value scenarios for use in \code{\link{power.trend}}.
}

\usage{ generate.trend(nyears, mu1=0, change, change.type="A", type = c("linear", "incident",
        "step", "updown"), changeyear, symmetric=F) }

\arguments{
  \item{nyears}{Defines the number of time points for X axis}
  \item{mu1}{The mean Y value for the first time point}
  \item{change}{Difference between \code{mu1} and largest (or smallest) \code{mu_i}. Can be negative for a decreasing trend.}
  \item{change.type}{Whether the parameter \code{change} represents an additive ("A") or percentage ("M") change.}
  \item{type}{Type of trend to assess the power against. Can be any of \code{"linear"}, \code{"incident"},
              \code{"step"} or \code{"updown"}.
              See \code{examples} below for more details.}
  \item{changeyear}{Year in which change in gradient occurs, for options \code{'incident'} or \code{'updown'}.}
  \item{symmetric}{If \code{symmetric=T}, \code{nyears} is even and \code{changeyear = nyears / 2} then
                   \code{type='updown'} generates a pattern where the two middle years are at level \code{k}.} 
}
\details{
Assumes that surveys take place in years 1 to \code{nyears} (or could be any other equally spaced unit).
Generates a set of mean values (or signal) for a specified trend over that time period. The approach
is based on Fryer and Nicholson (1993, 1999). For \code{type="linear"}, the slope is generated by \code{b=k/(nyears-1)}.
If \code{type="updown"}, the slope until \code{changeyear} is generated by \code{b=k/(changeyears-1)}. After
\code{changeyear}, the slope is -b
(except for the special case outlined by the \code{symmetric} parameter above, where \code{changeyear}
and \code{changeyear+1} are k
and then the slope continues as -b).
}
\value{
Generates a data frame where the first column ($i) is year and the second column ($mu) is the mean value.
}
\references{
Fryer RJ & Nicholson MD (1993) The power of a contaminant monitoring programme to detect linear trends and
incidents. ICES Journal of Marine Science, 50, 161-168.

Fryer & Nicholson 1999 Using smoothers for comprehensive assessments of contaminant time series in marine biota.
ICES Journal of Marine Science, 56, 779-790.
 
}
\author{
David Maxwell: David.Maxwell@cefas.co.uk
}

\seealso{
\code{\link{power.trend}}, \code{\link{addnoise}}
}
\examples{
lin0 = generate.trend(nyears=10, change=0, type="linear")
lin5 = generate.trend(nyears=10, change=5, type="linear")
inc5 = generate.trend(nyears=10, change=5, type="incident", changeyear=6)
step5 = generate.trend(nyears=10, change=5, type="step", changeyear=6)
updeven = generate.trend(nyears=10, change=5, type="updown", changeyear=5, symmetric=TRUE)
updodd = generate.trend(nyears=9, change=5, type="updown", changeyear=3)

par(mfrow=c(2,3))
plot(lin0$i, lin0$mu, type="o", pch=16, xlab='Time', ylab='Y')
plot(lin5$i, lin5$mu, type="o", pch=16, xlab='Time', ylab='Y')
plot(inc5$i, inc5$mu, type="o", pch=16, xlab='Time', ylab='Y')
plot(step5$i, step5$mu, type="o", pch=16, xlab='Time', ylab='Y')
plot(updeven$i, updeven$mu, type="o", pch=16, xlab='Time', ylab='Y')
plot(updodd$i, updodd$mu, type="o", pch=16, xlab='Time', ylab='Y')
}
