% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/nested.R
\name{add_grouping}
\alias{add_grouping}
\title{Add a grouping factor}
\usage{
add_grouping(object, newname, refname, newlevs)
}
\arguments{
\item{object}{An \code{emmGrid} object}

\item{newname}{Character name of grouping factor to add (different from any
existing factor in the grid)}

\item{refname}{Character name(s) of the reference factor(s)}

\item{newlevs}{Character vector or factor of the same length as that of the (combined) levels for 
\code{refname}. The grouping factor \code{newname} will have the unique
values of \code{newlevs} as its levels. The order of levels in \code{newlevs}
is the same as the order of the level combinations produced by 
\code{\link{expand.grid}} applied to the levels of \code{refname} -- that is, the
first factor's levels change the fastest and the last one's vary the slowest.}
}
\value{
A revised \code{emmGrid} object having an additional factor named 
  \code{newname}, and a new nesting structure with each \code{refname \%in\% newname}
}
\description{
This function adds a grouping factor to an existing reference grid or other 
\code{emmGrid} object, such that the levels of one or more existing factors (call them the
reference factors) are mapped to a smaller number of levels of the new
grouping factor. The reference factors are then nested in the new grouping factor. 
This facilitates obtaining marginal means of the grouping factor, and 
contrasts thereof.
}
\note{
By default, the levels of \code{newname} will be ordered
  alphabetically. To dictate a different ordering of levels, supply 
  \code{newlevs} as a \code{factor} having its levels in the desired order.
}
\examples{
fiber.lm <- lm(strength ~ diameter + machine, data = fiber)
( frg <- ref_grid(fiber.lm) )

# Suppose the machines are two different brands
brands <- factor(c("FiberPro", "FiberPro", "Acme"), levels = c("FiberPro", "Acme"))
( gfrg <- add_grouping(frg, "brand", "machine", brands) )

emmeans(gfrg, "machine")

emmeans(gfrg, "brand")

### More than one reference factor
warp.lm <- lm(breaks ~ wool * tension, data = warpbreaks)
gwrg <- add_grouping(ref_grid(warp.lm), 
    "prod",  c("tension", "wool"),  c(2, 1, 1,  1, 2, 1))
        # level combinations:         LA MA HA  LB MB HB

emmeans(gwrg, ~ wool * tension)   # some NAs due to impossible combinations

emmeans(gwrg, "prod")

}
