#' logLik.NestsResult Return Log Likelihood of a fit
#' @title Return Log Likelihood of a fit generated by searchR
#' @author Marc Girondot
#' @return The Log Likelihood value of the fitted model and data
#' @param object A result file generated by searchR
#' @param ... Not used
#' @description Return Log Likelihood of a fit generated by searchR
#' @examples
#' \dontrun{
#' library(embryogrowth)
#' data(resultNest_4p_SSM4p)
#' logLik(resultNest_4p_SSM4p)
#' AIC(resultNest_4p_SSM4p)
#' }
#' @method logLik NestsResult
#' @export


logLik.NestsResult <- function(object, ...) {
  l <- -object$value
  attributes(l) <- list(nall=object$data$IndiceT["NbTS"] , nobs=object$data$IndiceT["NbTS"] , df=length(object$par) , class="logLik")
  return(l)
}
