% Generated by roxygen2 (4.0.2): do not edit by hand
\name{predict.tsd}
\alias{predict.tsd}
\title{Estimate sex ratio according to constant incubation temperature}
\usage{
\method{predict}{tsd}(object, temperatures = NULL, durations = NULL,
  range.CI = 0.95, ...)
}
\arguments{
\item{object}{A result file generated by tsd}

\item{temperatures}{A vector of temperatures}

\item{durations}{A vector of durations}

\item{range.CI}{The range of confidence interval for estimation, default=0.95}

\item{...}{Not used}
}
\value{
A list with informations about sex-ratio
}
\description{
Estimate sex ratio according to constant incubation temperature
The list has the following components:
$sexratio $CI.minus.sexratio $CI.plus.sexratio $range.CI
if range.CI is set to NULL, the confidence interval is not estimated
}
\details{
predict.tsd Estimate sex ratio according to constant incubation temperature
}
\examples{
\dontrun{
library(embryogrowth)
m <- c(10, 14, 7, 4, 3, 0, 0)
f <- c(0, 1, 2, 4, 15, 10, 13)
t <- c(25, 26, 27, 28, 29, 30, 31)
result <- tsd(males=m, females=f, temperatures=t)
predict(result, temperatures=c(25, 31))
}
}
\author{
Marc Girondot
}

