% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{get_observed_model_predictions}
\alias{get_observed_model_predictions}
\title{Subset the model predictions to the (true) observed synergies}
\usage{
get_observed_model_predictions(model.predictions, observed.synergies)
}
\arguments{
\item{model.predictions}{a \code{data.frame} object with rows the models and
columns the drug combinations. Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)}

\item{observed.synergies}{a character vector with elements the names of the
drug combinations that were found as synergistic}
}
\value{
a \code{data.frame} object with rows the models
and columns the drug combinations that were found/observed as \strong{synergistic}
(\emph{positive results}). Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)
}
\description{
Subset the model predictions to the (true) observed synergies
}
