% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/analysis.R
\name{calculate_models_mcc}
\alias{calculate_models_mcc}
\title{Calculate the Matthews correlation coefficient for each model}
\usage{
calculate_models_mcc(observed.model.predictions,
  unobserved.model.predictions, number.of.drug.comb.tested)
}
\arguments{
\item{observed.model.predictions}{\code{data.frame} object with rows the models
and columns the drug combinations that were found as \strong{synergistic}
(\emph{positive results}). Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)}

\item{unobserved.model.predictions}{\code{data.frame} object with rows the models
and columns the drug combinations that were found as \strong{non-synergistic}
(\emph{negative results}). Possible values for each \emph{model-drug combination
element} are either \emph{0} (no synergy predicted), \emph{1} (synergy was
predicted) or \emph{NA} (couldn't find stable states in either the drug
combination inhibited model or in any of the two single-drug inhibited models)}

\item{number.of.drug.comb.tested}{numeric. The total number of drug
combinations tested, which should be equal to the sum of the columns of the
\code{observed.model.predictions} and the \code{unobserved.model.predictions}.}
}
\value{
a numeric vector of MCC values, each value being in the [-1,1]
interval or \emph{NaN}. The \emph{names} attribute holds the models' names.
}
\description{
Calculate the Matthews correlation coefficient for each model
}
\seealso{
Other confusion matrix calculation functions: \code{\link{calculate_mcc}},
  \code{\link{calculate_models_synergies_fn}},
  \code{\link{calculate_models_synergies_fp}},
  \code{\link{calculate_models_synergies_tn}},
  \code{\link{calculate_models_synergies_tp}}
}
\concept{confusion matrix calculation functions}
